﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Selection_Sort
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        // Metoda SelectionSort() akceptuje argument w postaci tablicy typu int.
        // Do sortowania tablicy używa algorytmu sortowania przez wybieranie.
        private void SelectionSort(int[] iArray)
        {
            int minIndex; // Indeks najmniejszej wartości w analizowanym fragmencie tablicy.
            int minValue; // Najmniejsza wartość w analizowanym fragmencie tablicy.

            // Pętla zewnętrzna przeprowadza iterację przez wszystkie elementy tablicy,
            // z wyłączeniem ostatniego. Zmienna startScan wskazuje położenie, od
            // którego powinna rozpocząć się iteracja.
            for (int startScan = 0; startScan < iArray.Length - 1; startScan++)
            {
                // Przyjmujemy założenie, że pierwszy element w analizowanym
                // fragmencie tablicy zawiera najmniejszą wartość.
                minIndex = startScan;
                minValue = iArray[startScan];

                // Sprawdzenie tablicy, począwszy od drugiego elementu w analizowanym
                // fragmencie tablicy, i odszukanie najmniejszej wartości.
                for (int index = startScan + 1; index < iArray.Length; index++)
                {
                    if (iArray[index] < minValue)
                    {
                        minValue = iArray[index];
                        minIndex = index;
                    }
                }

                // Zamiana elementów miejscami: tego o najmniejszej wartości
                // z pierwszym znajdującym się w analizowanym fragmencie tablicy.
                Swap(ref iArray[minIndex], ref iArray[startScan]);
            }
        }

        // Metoda Swap() akceptuje argumenty w postaci dwóch liczb całkowitych
        // przekazanych przez referencję i zamienia miejscami ich zawartość.
        private void Swap(ref int a, ref int b)
        {
            int temp = a;
            a = b;
            b = temp;
        }


        private void goButton_Click(object sender, EventArgs e)
        {
            // Utworzenie tablicy liczb całkowitych.
            int[] numbers = { 4, 6, 1, 3, 5, 2 };

            // Wyświetlenie zawartości tablicy w jej kolejności początkowej.
            foreach (int value in numbers)
            {
                originalListBox.Items.Add(value);
            }

            // Sortowanie tablicy.
            SelectionSort(numbers);

            // Wyświetlenie zawartości tablicy po jej posortowaniu.
            foreach (int value in numbers)
            {
                sortedListBox.Items.Add(value);
            }
        }

        private void exitButton_Click(object sender, EventArgs e)
        {
            // Zamknięcie formularza. 
            this.Close();
        }
    }
}
